<?php
/**
 * Post custom layout template.
 *
 * @var string $location can be 'welcome' or 'settings'.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$layout_manager = vc_modules_manager()->get_module( 'vc-post-custom-layout' );
?>
<div id="vc_ui-panel-post-custom-layout" class="vc_post-custom-layout-wrapper vc_selected-post-custom-layout-visible-ne">
	<a class="vc_post-custom-layout control-btn <?php echo $layout_manager->check_if_layout_active( 'default', $location ) ? 'vc-active-post-custom-layout' : ''; ?>"
		href="<?php echo esc_url( $layout_manager->get_layout_href_by_layout_name( 'default' ) ); ?>"
		data-post-custom-layout="default"
	>
		<svg width="88" height="88" viewBox="0 0 88 88" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M44.0004 33.3762C32.2835 33.3762 22.7518 42.9071 22.7518 54.6228C22.7518 66.3394 32.2839 75.8712 44 75.8712C55.7156 75.8712 65.2468 66.3394 65.2468 54.6228C65.2472 42.9076 55.716 33.3762 44.0004 33.3762ZM24.8961 54.6228C24.8961 51.8539 25.49 49.224 26.5502 46.8489L35.6632 71.816C29.291 68.7189 24.8961 62.1844 24.8961 54.6228ZM44.0004 73.7275C42.1251 73.7275 40.3151 73.4524 38.6036 72.949L44.3351 56.2941L50.2084 72.3812C50.2464 72.4761 50.2927 72.5626 50.3444 72.6443C48.3587 73.3429 46.225 73.7275 44.0004 73.7275ZM46.6326 45.6664C47.7824 45.6059 48.8197 45.4845 48.8197 45.4845C49.8485 45.3626 49.728 43.8503 48.6973 43.9108C48.6973 43.9108 45.6033 44.1532 43.6052 44.1532C41.7286 44.1532 38.5731 43.9108 38.5731 43.9108C37.5434 43.8503 37.4233 45.424 38.4526 45.4845C38.4526 45.4845 39.4276 45.6059 40.456 45.6664L43.4321 53.8214L39.2514 66.3593L32.2958 45.6668C33.4474 45.6068 34.4825 45.4849 34.4825 45.4849C35.5113 45.3635 35.3899 43.8503 34.3597 43.9121C34.3597 43.9121 31.267 44.1545 29.2685 44.1545C28.9095 44.1545 28.4869 44.1452 28.0391 44.1315C31.4542 38.9446 37.3266 35.5204 44.0004 35.5204C48.9747 35.5204 53.5025 37.4217 56.9008 40.5351C56.8182 40.5307 56.7383 40.5196 56.6526 40.5196C54.7768 40.5196 53.4451 42.1543 53.4451 43.9103C53.4451 45.484 54.3525 46.8166 55.3208 48.3903C56.0481 49.6629 56.8959 51.2979 56.8959 53.6589C56.8959 55.2944 56.268 57.1913 55.4418 59.8345L53.5365 66.2021L46.6326 45.6664ZM53.604 71.136L59.4393 54.2652C60.5304 51.5403 60.8921 49.3613 60.8921 47.4224C60.8921 46.7199 60.8461 46.0669 60.7631 45.458C62.2556 48.1793 63.1048 51.3023 63.1039 54.6237C63.1034 61.6709 59.283 67.8243 53.604 71.136Z" fill="#BECBD1"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.27565 3.01007C3.12897 3.01007 3.01006 3.12898 3.01006 3.27566L3.01007 84.7243C3.01007 84.871 3.12898 84.9899 3.27566 84.9899L84.7243 84.9899C84.871 84.9899 84.9899 84.871 84.9899 84.7243L84.9899 3.27565C84.9899 3.12897 84.871 3.01006 84.7243 3.01006L70.5593 3.01006C69.7281 3.01006 69.0543 2.33624 69.0543 1.50503C69.0543 0.673827 69.7281 1.52208e-06 70.5593 1.34388e-06L84.7243 0C86.5334 -1.58156e-07 88 1.46656 88 3.27565L88 84.7243C88 86.5334 86.5334 88 84.7243 88L3.27566 88C1.46656 88 7.56499e-06 86.5334 7.40684e-06 84.7243L2.86369e-07 3.27566C1.28213e-07 1.46656 1.46656 7.27863e-06 3.27565 7.12047e-06L54.6237 3.58131e-06C55.4549 3.50865e-06 56.1288 0.673828 56.1288 1.50503C56.1288 2.33624 55.4549 3.01006 54.6237 3.01006L3.27565 3.01007Z" fill="#BECBD1"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0 22.7523C0 21.9211 0.673825 21.2473 1.50503 21.2473H86.495C87.3262 21.2473 88 21.9211 88 22.7523C88 23.5835 87.3262 24.2573 86.495 24.2573H1.50503C0.673825 24.2573 0 23.5835 0 22.7523Z" fill="#BECBD1"/>
			<path d="M13.9907 11.7303C13.9907 12.9772 12.98 13.9879 11.7331 13.9879C10.4863 13.9879 9.4756 12.9772 9.4756 11.7303C9.4756 10.4835 10.4863 9.4728 11.7331 9.4728C12.98 9.4728 13.9907 10.4835 13.9907 11.7303Z" fill="#BECBD1"/>
			<path d="M21.955 11.7303C21.955 12.9772 20.9443 13.9879 19.6975 13.9879C18.4507 13.9879 17.44 12.9772 17.44 11.7303C17.44 10.4835 18.4507 9.4728 19.6975 9.4728C20.9443 9.4728 21.955 10.4835 21.955 11.7303Z" fill="#BECBD1"/>
			<path d="M29.9263 11.7303C29.9263 12.9772 28.9156 13.9879 27.6688 13.9879C26.422 13.9879 25.4112 12.9772 25.4112 11.7303C25.4112 10.4835 26.422 9.4728 27.6688 9.4728C28.9156 9.4728 29.9263 10.4835 29.9263 11.7303Z" fill="#BECBD1"/>
		</svg>
		<span class="vc_layout-label"><?php esc_html_e( 'Default WordPress Theme Layout', 'js_composer' ); ?></span>
	</a>
	<a class="vc_post-custom-layout control-btn <?php echo $layout_manager->check_if_layout_active( 'blank', $location ) ? 'vc-active-post-custom-layout' : ''; ?>"
		href="<?php echo esc_url( $layout_manager->get_layout_href_by_layout_name( 'blank' ) ); ?>"
		data-post-custom-layout="blank"
	>
		<svg width="88" height="88" viewBox="0 0 88 88" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M38.6076 38.4225C30.1413 38.4225 23.3722 45.0271 23.3722 53.0599C23.3722 60.1787 28.6818 66.1703 35.7876 67.4473C36.5047 67.5762 37.0265 68.2003 37.0264 68.9289L37.0262 70.06C37.0263 70.4312 37.3544 70.825 37.8753 70.825H52C52.521 70.825 52.8491 70.4313 52.8491 70.06V69.2023C52.8491 68.8032 53.0077 68.4203 53.2899 68.1381C53.5722 67.8558 53.955 67.6973 54.3542 67.6973L55.3482 67.6973L55.5322 67.6959L55.5379 67.6958C61.6039 67.598 66.3984 62.84 66.3984 57.0956C66.3984 51.2915 61.5031 46.4938 55.3481 46.4938C54.7023 46.4938 54.071 46.5468 53.4583 46.6484C52.8418 46.7507 52.2262 46.4614 51.9116 45.9214C49.3118 41.46 44.3398 38.4225 38.6076 38.4225ZM55.8046 70.7004C55.4908 72.515 53.866 73.835 52 73.835H37.8753C35.8232 73.835 34.0628 72.2387 34.017 70.1437C26.195 68.1814 20.3622 61.3085 20.3622 53.0599C20.3622 43.2624 28.583 35.4125 38.6076 35.4125C45.0486 35.4125 50.7287 38.6441 53.9784 43.5476C54.4295 43.5053 54.8864 43.4837 55.3481 43.4837C63.0613 43.4837 69.4084 49.5268 69.4084 57.0956C69.4084 64.5143 63.3098 70.4679 55.8046 70.7004Z" fill="#BECBD1"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.27565 3.01007C3.12897 3.01007 3.01006 3.12898 3.01006 3.27566L3.01007 84.7243C3.01007 84.871 3.12898 84.9899 3.27566 84.9899L84.7243 84.9899C84.871 84.9899 84.9899 84.871 84.9899 84.7243L84.9899 3.27565C84.9899 3.12897 84.871 3.01006 84.7243 3.01006L70.5593 3.01006C69.7281 3.01006 69.0543 2.33624 69.0543 1.50503C69.0543 0.673827 69.7281 1.52208e-06 70.5593 1.34388e-06L84.7243 0C86.5334 -1.58156e-07 88 1.46656 88 3.27565L88 84.7243C88 86.5334 86.5334 88 84.7243 88L3.27566 88C1.46656 88 7.27863e-06 86.5334 7.12048e-06 84.7243L0 3.27566C-1.5815e-07 1.46656 1.46656 7.27863e-06 3.27565 7.12047e-06L54.6237 3.58131e-06C55.4549 3.50865e-06 56.1288 0.673828 56.1288 1.50503C56.1288 2.33624 55.4549 3.01006 54.6237 3.01006L3.27565 3.01007Z" fill="#BECBD1"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.54113e-06 22.7525C1.42726e-06 21.9213 0.673825 21.2475 1.50503 21.2475L86.495 21.2473C87.3262 21.2473 88 21.9211 88 22.7523C88 23.5835 87.3262 24.2573 86.495 24.2573L1.50504 24.2575C0.673832 24.2575 5.65499e-06 23.5837 3.54113e-06 22.7525Z" fill="#BECBD1"/>
			<path d="M13.9907 11.7303C13.9907 12.9772 12.98 13.9879 11.7331 13.9879C10.4863 13.9879 9.4756 12.9772 9.4756 11.7303C9.4756 10.4835 10.4863 9.4728 11.7331 9.4728C12.98 9.4728 13.9907 10.4835 13.9907 11.7303Z" fill="#BECBD1"/>
			<path d="M21.955 11.7303C21.955 12.9772 20.9443 13.9879 19.6975 13.9879C18.4507 13.9879 17.44 12.9772 17.44 11.7303C17.44 10.4835 18.4507 9.4728 19.6975 9.4728C20.9443 9.4728 21.955 10.4835 21.955 11.7303Z" fill="#BECBD1"/>
			<path d="M29.9263 11.7303C29.9263 12.9772 28.9156 13.9879 27.6688 13.9879C26.422 13.9879 25.4112 12.9772 25.4112 11.7303C25.4112 10.4835 26.422 9.4728 27.6688 9.4728C28.9156 9.4728 29.9263 10.4835 29.9263 11.7303Z" fill="#BECBD1"/>
		</svg>
		<span class="vc_layout-label"><?php esc_html_e( 'Blank Page Layout by WPBakery', 'js_composer' ); ?></span>
	</a>
</div>
