(function () {
  if (!window.wc || !window.wc.wcBlocksRegistry) return;

  const register = window.wc.wcBlocksRegistry.registerPaymentMethodExtensionCallbacks;
  if (typeof register !== "function") return;

  const data = window.CODARAB_BGC_RULES || {};
  const rules = Array.isArray(data.rules) ? data.rules : [];
  if (!rules.length) return;

  // gatewayId -> Set(countries)
  const byGateway = {};
  rules.forEach((r) => {
    const g = (r.gateway || "").toString();
    const c = (r.country || "").toString().toUpperCase();
    if (!g || !c) return;
    if (!byGateway[g]) byGateway[g] = new Set();
    byGateway[g].add(c);
  });

  const callbacks = {};
  Object.keys(byGateway).forEach((gatewayId) => {
    callbacks[gatewayId] = (arg) => {
      const billing = (arg?.billingAddress?.country || "").toUpperCase();
      const shipping = (arg?.shippingAddress?.country || "").toUpperCase();
      const effective = billing || shipping;

      // If the block checkout doesn't have a selected country yet, allow it here;
      // PHP side still blocks by IP.
      if (!effective) return true;

      return !byGateway[gatewayId].has(effective);
    };
  });

  register("codarab-bgc", callbacks);
})();
