<?php
/*
Plugin Name: Fees For Payment Methods
Description:  Fees By Payment Methods Selected
Version: 1.0
Author: Codarab Payment
Author URI: https://codarab.com/
*/
 
class feesPaymentMethods {

    public function __construct() {
            add_action('admin_menu', array($this, 'payment_methods_fees__Menu'));
            add_action('woocommerce_after_checkout_form', array($this, 'payment_method_checkout_fee_js'));
            add_action('woocommerce_cart_calculate_fees', array($this, 'payment_method_checkout_fee'));

    }

    public function payment_methods_fees__Menu() {
        add_menu_page('Payment Methods Fee', 'Payment Methods Fee', 'manage_options', 'payment_methods_fees', array($this, 'payment_methods_fees__admin'), 'dashicons-money-alt');
    }


    public function payment_methods_fees__admin() {
        $gateways = WC()->payment_gateways->get_available_payment_gateways();
        $isUpdated = false;
        foreach ($gateways as $gateway) {
            
            if(isset($_POST[$gateway->id . '_payment_method_fee']) || isset($_POST[$gateway->id . '_payment_method_percentage'])){
                
                $getGateWayfee  = sanitize_text_field($_POST[$gateway->id . '_payment_method_fee']);
                $getGateWayfee_percentage = sanitize_text_field($_POST[$gateway->id . '_payment_method_percentage']);
                
                if(!is_numeric($getGateWayfee_percentage)){
                    $getGateWayfee_percentage = '';
                }

                if(!is_numeric($getGateWayfee)){
                    $getGateWayfee = '';
                }
                
                update_option($gateway->id . '_payment_method_fee', $getGateWayfee);
                update_option($gateway->id . '_payment_method_percentage', $getGateWayfee_percentage);
                $isUpdated = true;
            ?>    
            <?php    
                
            }
            
            
        }
        ?>
    <div class="wrap">
        <form id="register_form" method="post" action="<?php echo site_url() ?>/wp-admin/admin.php?page=payment_methods_fees">

            <?php
            
            foreach ($gateways as $gateway) {
                
                    $getGateWayfee  = get_option($gateway->id . '_payment_method_fee', '');
                    $getGateWayfee_percentage  = get_option($gateway->id . '_payment_method_percentage', '');
                    
                    ?>
    
                    <div class="method-<?php echo $gateway->id; ?>">
                        <table>
                            <tr>
                            <td style="width:200px"><strong><?php echo $gateway->title; ?> (<?php echo $gateway->id; ?>)</strong></td>
                                <td><input type="text" name="<?php echo $gateway->id; ?>_payment_method_fee" value="<?php echo esc_attr($getGateWayfee); ?>" Placeholder="Fee"  /></td>
                                <td><input type="text" name="<?php echo $gateway->id; ?>_payment_method_percentage" value="<?php echo esc_attr($getGateWayfee_percentage); ?>" Placeholder="Fee Percentage" /></td>
                            </tr>
                        </table>
                    </div>
    
                    <?php
                
            }
            ?>
    
           <div style="display: flex;align-items: center;gap: 20px;">
                <?php  submit_button() ?><?php echo $isUpdated == true ? '<span class="dashicons dashicons-yes-alt" style="color: #09e709;font-size: 28px;"></span>' : '';  ?>
            </div>
            <p id="errors"></p>
        </form>     
        </div>        
        <?php
    }

    public function payment_method_checkout_fee() {
        
        $payment_method = WC()->session->get('chosen_payment_method');
        $gateways = WC()->payment_gateways->get_available_payment_gateways();
        $enabled_gateways = [];

        foreach ($gateways as $gateway) {
            if ($gateway->enabled == 'yes') {
                $enabled_gateways[] = $gateway;
                $methodtitle = $gateway->title;
                $methodslug = $gateway->id;

                if ($payment_method == $methodslug) {  
                    
                    $getGateWayfee  = get_option($gateway->id . '_payment_method_fee');
                    $getGateWayfee_percentage  = get_option($gateway->id . '_payment_method_percentage');
                    
                    if(!empty($getGateWayfee)){
                        WC()->cart->add_fee('Fix Fee', $getGateWayfee, true, 'standard');
                    }
                    
                    if(!empty($getGateWayfee_percentage)){

                        $cartTotal = WC()->cart->get_cart_contents_total();
                        $CartFee = ($cartTotal / 100) * $getGateWayfee_percentage;

                        WC()->cart->add_fee('Percent Fee', $CartFee, true, 'standard');

                    }                    
                    
                }
            }
        }
    }


    public function payment_method_checkout_fee_js() {
        ?>
        <script>
            jQuery(document).ready(function($) {
               
                $('body').on('change', '.woocommerce-checkout input[type="radio"]', function() {
                     console.log('teset');
                    $('body').trigger('update_checkout');
                });
            });
        </script>
        <?php
    }
}

new feesPaymentMethods();
 