<?php
/*
Plugin Name: Restrict Last Product Checkout
Description: Allows only the last added product in the cart during checkout.
Version: 1.0
Author: Codarab Payment 
* Author URI:  https://codarab.com/
*/

// Hook to check cart items before proceeding to checkout
add_action('woocommerce_check_cart_items', 'restrict_last_product_checkout');

function restrict_last_product_checkout() {
    // Get cart contents
    $cart_contents = WC()->cart->get_cart();
    
    // If cart is empty, no need to restrict
    if (empty($cart_contents)) {
        return;
    }

    // Get the last added product's key
    $last_item_key = end(array_keys($cart_contents));

    // Remove all other products from the cart
    foreach ($cart_contents as $cart_key => $cart_item) {
        if ($cart_key !== $last_item_key) {
            WC()->cart->remove_cart_item($cart_key);
        }
    }
}